<?php
require_once 'config.php';
startSession();
requireLogin();

$pageTitle = 'Từ Vựng';
require_once 'includes/header.php';

$level = isset($_GET['level']) ? intval($_GET['level']) : 0;
if ($level < 1 || $level > 4) $level = 0;
?>

<main>
    <section class="vocabulary-section">
        <div class="container">
            <h1 class="page-title">Từ Vựng HSK <?php echo $level > 0 ? $level : '1-4'; ?></h1>
            
            <div class="filter-section">
                <div class="level-filters">
                    <a href="vocabulary.php" class="level-btn <?php echo $level == 0 ? 'active' : ''; ?>">Tất Cả</a>
                    <a href="vocabulary.php?level=1" class="level-btn <?php echo $level == 1 ? 'active' : ''; ?>">HSK 1</a>
                    <a href="vocabulary.php?level=2" class="level-btn <?php echo $level == 2 ? 'active' : ''; ?>">HSK 2</a>
                    <a href="vocabulary.php?level=3" class="level-btn <?php echo $level == 3 ? 'active' : ''; ?>">HSK 3</a>
                    <a href="vocabulary.php?level=4" class="level-btn <?php echo $level == 4 ? 'active' : ''; ?>">HSK 4</a>
                </div>
                
                <div class="search-box">
                    <input type="text" id="search-input" placeholder="Tìm kiếm từ vựng, pinyin hoặc nghĩa...">
                    <button id="search-btn" class="btn btn-primary">Tìm Kiếm</button>
                </div>
                
                <div class="results-info">
                    <span id="results-count">Đang tải...</span>
                </div>
            </div>

            <div class="vocabulary-list" id="vocabulary-list">
                <div class="loading">
                    <div class="spinner"></div>
                    <p>Đang tải từ vựng...</p>
                </div>
            </div>

            <div class="pagination" id="pagination"></div>
        </div>
    </section>
</main>

<script src="assets/js/vocabulary.js"></script>
<script>
    // Set initial level
    window.initialLevel = <?php echo $level; ?>;
</script>

<?php require_once 'includes/footer.php'; ?>
