<?php
$pageTitle = 'Đăng Ký';
require_once 'config.php';
startSession();

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    $full_name = trim($_POST['full_name'] ?? '');
    
    // Validation
    if (empty($username) || empty($email) || empty($password)) {
        $error = 'Vui lòng điền đầy đủ thông tin';
    } elseif (strlen($username) < 3 || strlen($username) > 50) {
        $error = 'Tên đăng nhập phải từ 3-50 ký tự';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Email không hợp lệ';
    } elseif (strlen($password) < 6) {
        $error = 'Mật khẩu phải có ít nhất 6 ký tự';
    } elseif ($password !== $confirm_password) {
        $error = 'Mật khẩu xác nhận không khớp';
    } else {
        $conn = getDB();
        
        if (!$conn) {
            $error = 'Không thể kết nối đến cơ sở dữ liệu. Vui lòng thử lại sau.';
        } else {
            // Check if username exists
            $stmt = $conn->prepare("SELECT id FROM users WHERE username = ?");
            if (!$stmt) {
                $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
            } else {
                $stmt->bind_param("s", $username);
                if (!$stmt->execute()) {
                    $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
                    $stmt->close();
                } else {
                    if (getStmtNumRows($stmt) > 0) {
                        $error = 'Tên đăng nhập đã tồn tại';
                        $stmt->close();
                    } else {
                        $stmt->close();
                        
                        // Check if email exists
                        $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
                        if (!$stmt) {
                            $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
                        } else {
                            $stmt->bind_param("s", $email);
                            if (!$stmt->execute()) {
                                $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
                                $stmt->close();
                            } else {
                                if (getStmtNumRows($stmt) > 0) {
                                    $error = 'Email đã được sử dụng';
                                    $stmt->close();
                                } else {
                                    $stmt->close();
                                    
                                    // Create user
                                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                                    $stmt = $conn->prepare("INSERT INTO users (username, email, password, full_name) VALUES (?, ?, ?, ?)");
                                    if (!$stmt) {
                                        $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
                                    } else {
                                        $stmt->bind_param("ssss", $username, $email, $hashed_password, $full_name);
                                        
                                        if ($stmt->execute()) {
                                            $stmt->close();
                                            $success = 'Đăng ký thành công! Vui lòng đăng nhập.';
                                            header('Location: login.php?registered=1');
                                            exit;
                                        } else {
                                            $error = 'Có lỗi xảy ra. Vui lòng thử lại.';
                                            $stmt->close();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - Học Tiếng Trung HSK</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/auth.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1>中文学习</h1>
                <p>Đăng Ký Tài Khoản</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
            <?php endif; ?>
            
            <form method="POST" class="auth-form">
                <div class="form-group">
                    <label for="full_name">Họ và Tên</label>
                    <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($_POST['full_name'] ?? ''); ?>" placeholder="Nhập họ và tên">
                </div>
                
                <div class="form-group">
                    <label for="username">Tên Đăng Nhập *</label>
                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required placeholder="Từ 3-50 ký tự">
                </div>
                
                <div class="form-group">
                    <label for="email">Email *</label>
                    <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required placeholder="your@email.com">
                </div>
                
                <div class="form-group">
                    <label for="password">Mật Khẩu *</label>
                    <input type="password" id="password" name="password" required placeholder="Tối thiểu 6 ký tự">
                </div>
                
                <div class="form-group">
                    <label for="confirm_password">Xác Nhận Mật Khẩu *</label>
                    <input type="password" id="confirm_password" name="confirm_password" required placeholder="Nhập lại mật khẩu">
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">Đăng Ký</button>
            </form>
            
            <div class="auth-footer">
                <p>Đã có tài khoản? <a href="login.php">Đăng nhập</a></p>
                <p><a href="index.php">← Về trang chủ</a></p>
            </div>
        </div>
    </div>
</body>
</html>
