<?php
require_once 'config.php';
startSession();
$currentUser = getCurrentUser();
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kiểm Tra - Học Tiếng Trung</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <h1>中文学习</h1>
                <span>HSK Vocabulary Learning</span>
            </div>
            <ul class="nav-menu">
                <li><a href="index.php">Trang Chủ</a></li>
                <li><a href="vocabulary.php">Từ Vựng</a></li>
                <li><a href="flashcard.php">Flashcard</a></li>
                <li><a href="quiz.php" class="active">Kiểm Tra</a></li>
                <?php if ($currentUser): ?>
                    <li class="user-menu">
                        <a href="#" class="user-menu-toggle">
                            <?php echo htmlspecialchars($currentUser['full_name'] ?? $currentUser['username']); ?>
                            <span class="user-menu-arrow">▼</span>
                        </a>
                        <ul class="user-dropdown">
                            <li><a href="profile.php">Hồ Sơ</a></li>
                            <?php if (isAdmin()): ?>
                                <li><a href="admin/index.php">Admin Panel</a></li>
                            <?php endif; ?>
                            <li><a href="logout.php">Đăng Xuất</a></li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li><a href="login.php">Đăng Nhập</a></li>
                    <li><a href="register.php" class="btn-register">Đăng Ký</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </nav>

    <main>
        <section class="quiz-section">
            <div class="container">
                <h1 class="page-title">Kiểm Tra Từ Vựng</h1>
                
                <div class="quiz-setup" id="quiz-setup">
                    <div class="setup-card">
                        <h2>Cài Đặt Bài Kiểm Tra</h2>
                        <div class="setup-form">
                            <div class="form-group">
                                <label>Cấp độ HSK:</label>
                                <select id="quiz-level">
                                    <option value="all">Tất Cả</option>
                                    <option value="new-1">HSK 1</option>
                                    <option value="new-2">HSK 2</option>
                                    <option value="new-3">HSK 3</option>
                                    <option value="new-4">HSK 4</option>
                                    <option value="new-5">HSK 5</option>
                                    <option value="new-6">HSK 6</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Số câu hỏi:</label>
                                <select id="quiz-count">
                                    <option value="10">10 câu</option>
                                    <option value="20" selected>20 câu</option>
                                    <option value="30">30 câu</option>
                                    <option value="50">50 câu</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Loại câu hỏi:</label>
                                <select id="quiz-type">
                                    <option value="meaning">Chọn nghĩa đúng</option>
                                    <option value="pinyin">Chọn pinyin đúng</option>
                                    <option value="mixed" selected>Hỗn hợp</option>
                                </select>
                            </div>
                            <button id="start-quiz" class="btn btn-primary btn-large">Bắt Đầu Kiểm Tra</button>
                        </div>
                    </div>
                </div>

                <div class="quiz-container" id="quiz-container" style="display: none;">
                    <div class="quiz-header">
                        <div class="quiz-progress">
                            <div class="progress-bar">
                                <div class="progress-fill" id="quiz-progress-fill"></div>
                            </div>
                            <div class="progress-text">
                                Câu <span id="quiz-current">0</span> / <span id="quiz-total">0</span>
                            </div>
                        </div>
                        <div class="quiz-score">
                            Điểm: <span id="quiz-score">0</span>
                        </div>
                    </div>

                    <div class="quiz-question" id="quiz-question">
                        <!-- Question will be loaded here -->
                    </div>

                    <div class="quiz-options" id="quiz-options">
                        <!-- Options will be loaded here -->
                    </div>

                    <div class="quiz-feedback" id="quiz-feedback" style="display: none;">
                        <!-- Feedback will be shown here -->
                    </div>

                    <div class="quiz-actions">
                        <button id="next-question" class="btn btn-primary" style="display: none;">Câu Tiếp Theo</button>
                    </div>
                </div>

                <div class="quiz-result" id="quiz-result" style="display: none;">
                    <div class="result-card">
                        <h2>Kết Quả Kiểm Tra</h2>
                        <div class="result-score">
                            <div class="score-circle">
                                <span id="result-percentage">0</span>%
                            </div>
                            <div class="score-details">
                                <p>Đúng: <span id="result-correct">0</span></p>
                                <p>Sai: <span id="result-wrong">0</span></p>
                                <p>Tổng: <span id="result-total">0</span> câu</p>
                            </div>
                        </div>
                        <div class="result-actions">
                            <button id="restart-quiz" class="btn btn-primary">Làm Lại</button>
                            <a href="vocabulary.php" class="btn btn-secondary">Xem Từ Vựng</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="footer">
        <div class="container">
            <p>&copy; 2024 Học Tiếng Trung HSK. Tất cả quyền được bảo lưu.</p>
        </div>
    </footer>

    <script src="assets/js/quiz.js"></script>
</body>
</html>

