<?php
$pageTitle = 'Đăng Nhập';
require_once 'config.php';
startSession();

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$error = '';
$success = '';

if (isset($_GET['registered']) && $_GET['registered'] == '1') {
    $success = 'Đăng ký thành công! Vui lòng đăng nhập.';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember = isset($_POST['remember']);
    
    if (empty($username) || empty($password)) {
        $error = 'Vui lòng điền đầy đủ thông tin';
    } else {
        $conn = getDB();
        if (!$conn) {
            $error = 'Không thể kết nối đến cơ sở dữ liệu. Vui lòng thử lại sau.';
        } else {
            $stmt = $conn->prepare("SELECT id, username, email, password, full_name, is_admin, status FROM users WHERE username = ? OR email = ?");
            if (!$stmt) {
                $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
            } else {
                $stmt->bind_param("ss", $username, $username);
                if (!$stmt->execute()) {
                    $error = 'Có lỗi xảy ra. Vui lòng thử lại sau.';
                    $stmt->close();
                } else {
                    $numRows = getStmtNumRows($stmt);
        
                    if ($numRows === 1) {
                        $user = fetchStmtAssoc($stmt);
                        
                        if ($user['status'] === 'banned') {
                            $error = 'Tài khoản của bạn đã bị khóa';
                        } elseif ($user['status'] === 'inactive') {
                            $error = 'Tài khoản của bạn đã bị vô hiệu hóa';
                        } elseif (password_verify($password, $user['password'])) {
                            // Login successful
                            $_SESSION['user_id'] = $user['id'];
                            $_SESSION['username'] = $user['username'];
                            $_SESSION['full_name'] = $user['full_name'];
                            $_SESSION['is_admin'] = $user['is_admin'];
                            
                            // Update last login
                            $updateStmt = $conn->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
                            if ($updateStmt) {
                                $updateStmt->bind_param("i", $user['id']);
                                $updateStmt->execute();
                                $updateStmt->close();
                            }
                            
                            // Set remember me cookie
                            if ($remember) {
                                setcookie('remember_token', base64_encode($user['id'] . ':' . $username), time() + (86400 * 30), '/');
                            }
                            
                            $stmt->close();
                            
                            // Redirect to saved URL or based on user type
                            if (isset($_SESSION['redirect_after_login'])) {
                                $redirectUrl = $_SESSION['redirect_after_login'];
                                unset($_SESSION['redirect_after_login']);
                                header('Location: ' . $redirectUrl);
                            } else if ($user['is_admin']) {
                                header('Location: admin/index.php');
                            } else {
                                header('Location: index.php');
                            }
                            exit;
                        } else {
                            $error = 'Tên đăng nhập hoặc mật khẩu không đúng';
                        }
                    } else {
                        $error = 'Tên đăng nhập hoặc mật khẩu không đúng';
                    }
                    $stmt->close();
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?> - Học Tiếng Trung HSK</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/auth.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1>中文学习</h1>
                <p>Đăng Nhập</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
            <?php endif; ?>
            
            <form method="POST" class="auth-form">
                <div class="form-group">
                    <label for="username">Tên Đăng Nhập hoặc Email</label>
                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required autofocus placeholder="Nhập tên đăng nhập hoặc email">
                </div>
                
                <div class="form-group">
                    <label for="password">Mật Khẩu</label>
                    <input type="password" id="password" name="password" required placeholder="Nhập mật khẩu">
                </div>
                
                <div class="form-group checkbox-group">
                    <label>
                        <input type="checkbox" name="remember" value="1">
                        <span>Ghi nhớ đăng nhập</span>
                    </label>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">Đăng Nhập</button>
            </form>
            
            <div class="auth-footer">
                <p>Chưa có tài khoản? <a href="register.php">Đăng ký ngay</a></p>
                <p><a href="index.php">← Về trang chủ</a></p>
            </div>
        </div>
    </div>
</body>
</html>
