<?php
/**
 * Installation script for HSK Learning Website
 * Run this file once to set up the database
 */

require_once 'config.php';

// Check if database connection is working
try {
    $conn = getDB();
    echo "<h1>Database Installation</h1>";
    echo "<p style='color: green;'>✓ Database connection successful!</p>";
    
    // Check if tables exist
    $tables = ['users', 'user_progress', 'quiz_results'];
    $allTablesExist = true;
    
    foreach ($tables as $table) {
        $result = $conn->query("SHOW TABLES LIKE '$table'");
        if ($result->num_rows > 0) {
            echo "<p style='color: green;'>✓ Table '$table' exists</p>";
        } else {
            echo "<p style='color: orange;'>✗ Table '$table' does not exist</p>";
            $allTablesExist = false;
        }
    }
    
    if ($allTablesExist) {
        // Check if admin user exists
        $adminCheck = $conn->query("SELECT id FROM users WHERE username = 'admin'");
        if ($adminCheck->num_rows > 0) {
            echo "<p style='color: green;'>✓ Admin user exists</p>";
        } else {
            echo "<p style='color: orange;'>✗ Admin user does not exist (will be created automatically)</p>";
        }
        
        echo "<h2>Installation Complete!</h2>";
        echo "<p><a href='index.php'>Go to Homepage</a></p>";
        echo "<p><strong>Default Admin Credentials:</strong></p>";
        echo "<ul>";
        echo "<li>Username: admin</li>";
        echo "<li>Password: admin123</li>";
        echo "</ul>";
        echo "<p style='color: red;'><strong>⚠ Please change the admin password after first login!</strong></p>";
    } else {
        echo "<p style='color: red;'>Some tables are missing. Please check your database configuration.</p>";
    }
    
} catch (Exception $e) {
    echo "<h1>Database Installation Error</h1>";
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
    echo "<h2>Please check:</h2>";
    echo "<ul>";
    echo "<li>MySQL/MariaDB is running</li>";
    echo "<li>Database credentials in config.php are correct</li>";
    echo "<li>Database user has CREATE DATABASE and CREATE TABLE permissions</li>";
    echo "</ul>";
    echo "<h2>Manual Installation:</h2>";
    echo "<p>If automatic installation fails, you can:</p>";
    echo "<ol>";
    echo "<li>Create database manually: <code>CREATE DATABASE hsk_learning CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;</code></li>";
    echo "<li>Import database.sql file via phpMyAdmin or MySQL command line</li>";
    echo "<li>Refresh this page</li>";
    echo "</ol>";
}
?>

