<?php
$pageTitle = 'Trang Chủ';
require_once 'includes/header.php';
?>

<main>
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1 class="hero-title">Học Tiếng Trung Quốc</h1>
                <p class="hero-subtitle">Hệ thống học từ vựng HSK từ cấp độ 1 đến 4</p>
                
                <div class="hsk-levels">
                    <a href="vocabulary.php?level=1" class="hsk-level-card level-1">
                        <div class="level-number">1</div>
                        <div class="level-info">
                            <h3>HSK 1</h3>
                            <p id="hsk1-words">-</p>
                        </div>
                    </a>
                    <a href="vocabulary.php?level=2" class="hsk-level-card level-2">
                        <div class="level-number">2</div>
                        <div class="level-info">
                            <h3>HSK 2</h3>
                            <p id="hsk2-words">-</p>
                        </div>
                    </a>
                    <a href="vocabulary.php?level=3" class="hsk-level-card level-3">
                        <div class="level-number">3</div>
                        <div class="level-info">
                            <h3>HSK 3</h3>
                            <p id="hsk3-words">-</p>
                        </div>
                    </a>
                    <a href="vocabulary.php?level=4" class="hsk-level-card level-4">
                        <div class="level-number">4</div>
                        <div class="level-info">
                            <h3>HSK 4</h3>
                            <p id="hsk4-words">-</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="features">
        <div class="container">
            <h2 class="section-title">Tính Năng Học Tập</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">📚</div>
                    <h3>Từ Vựng</h3>
                    <p>Tra cứu và học từ vựng theo từng cấp độ HSK 1-4 với đầy đủ thông tin: pinyin, nghĩa, từ loại</p>
                    <a href="vocabulary.php" class="btn btn-primary">Xem Từ Vựng</a>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🃏</div>
                    <h3>Flashcard</h3>
                    <p>Học từ vựng bằng flashcard, luyện tập ghi nhớ hiệu quả với chế độ lật thẻ 3D</p>
                    <a href="flashcard.php" class="btn btn-primary">Bắt Đầu Học</a>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">✍️</div>
                    <h3>Bài Tập</h3>
                    <p>Luyện tập với các bài tập đa dạng theo từng cấp độ HSK: điền từ, chọn đáp án, nghe và viết</p>
                    <a href="exercises.php" class="btn btn-primary">Làm Bài Tập</a>
                </div>
                <?php if ($currentUser): ?>
                <div class="feature-card">
                    <div class="feature-icon">📊</div>
                    <h3>Theo Dõi Tiến Độ</h3>
                    <p>Xem tiến độ học tập, từ vựng đã học, và kết quả bài tập của bạn</p>
                    <a href="profile.php" class="btn btn-primary">Xem Hồ Sơ</a>
                </div>
                <?php else: ?>
                <div class="feature-card">
                    <div class="feature-icon">👤</div>
                    <h3>Đăng Ký Ngay</h3>
                    <p>Đăng ký tài khoản miễn phí để lưu tiến độ học tập và theo dõi thành tích</p>
                    <a href="register.php" class="btn btn-primary">Đăng Ký</a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <?php if ($currentUser): ?>
    <section class="user-stats">
        <div class="container">
            <h2 class="section-title">Tiến Độ Học Tập Của Bạn</h2>
            <?php
            $userStats = [];
            for ($i = 1; $i <= 4; $i++) {
                $progress = getUserProgress($currentUser['id'], $i);
                $userStats[$i] = $progress ? $progress : ['total' => 0, 'known' => 0, 'learning' => 0];
            }
            ?>
            <div class="progress-grid">
                <?php for ($i = 1; $i <= 4; $i++): ?>
                    <div class="progress-card">
                        <h3>HSK <?php echo $i; ?></h3>
                        <div class="progress-bar-container">
                            <?php 
                            $total = $userStats[$i]['total'] ?? 0;
                            $known = $userStats[$i]['known'] ?? 0;
                            $percentage = $total > 0 ? round(($known / $total) * 100) : 0;
                            ?>
                            <div class="progress-bar">
                                <div class="progress-fill" style="width: <?php echo $percentage; ?>%"></div>
                            </div>
                            <p class="progress-text"><?php echo $known; ?> / <?php echo $total; ?> từ vựng (<?php echo $percentage; ?>%)</p>
                        </div>
                        <a href="vocabulary.php?level=<?php echo $i; ?>" class="btn btn-sm btn-primary">Học Tiếp</a>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>
</main>

<script src="assets/js/main.js"></script>
<?php require_once 'includes/footer.php'; ?>
