<?php
require_once __DIR__ . '/../config.php';
startSession();
$currentUser = getCurrentUser();
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>Học Tiếng Trung HSK</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <script src="assets/js/api-helper.js"></script>
</head>
<body>
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <h1>中文学习</h1>
                <span>HSK 1-4 Vocabulary</span>
            </div>
            <button class="mobile-menu-toggle" aria-label="Toggle menu">
                <span class="menu-icon">☰</span>
            </button>
            <ul class="nav-menu" id="navMenu">
                <li><a href="index.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">Trang Chủ</a></li>
                <li><a href="vocabulary.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'vocabulary.php' ? 'active' : ''; ?>">Từ Vựng</a></li>
                <li><a href="flashcard.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'flashcard.php' ? 'active' : ''; ?>">Flashcard</a></li>
                <li><a href="exercises.php" class="<?php echo basename($_SERVER['PHP_SELF']) == 'exercises.php' ? 'active' : ''; ?>">Bài Tập</a></li>
                <?php if ($currentUser): ?>
                    <li class="user-menu">
                        <a href="#" class="user-menu-toggle">
                            <?php echo htmlspecialchars($currentUser['full_name'] ?? $currentUser['username']); ?>
                            <span class="user-menu-arrow">▼</span>
                        </a>
                        <ul class="user-dropdown">
                            <li><a href="profile.php">Hồ Sơ</a></li>
                            <?php if (isAdmin()): ?>
                                <li><a href="admin/index.php">Admin Panel</a></li>
                            <?php endif; ?>
                            <li><a href="logout.php">Đăng Xuất</a></li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li><a href="login.php">Đăng Nhập</a></li>
                    <li><a href="register.php" class="btn-register">Đăng Ký</a></li>
                <?php endif; ?>
            </ul>
        </div>
    </nav>

