<?php
require_once 'config.php';
startSession();
requireLogin();

$pageTitle = 'Flashcard';
require_once 'includes/header.php';

$level = isset($_GET['level']) ? intval($_GET['level']) : 0;
if ($level < 1 || $level > 4) $level = 0;
?>

<main>
    <section class="flashcard-section">
        <div class="container">
            <h1 class="page-title">Flashcard Học Từ Vựng</h1>
            
            <?php if ($level == 0): ?>
            <div class="level-selector">
                <h2>Chọn Cấp Độ HSK</h2>
                <div class="hsk-levels">
                    <a href="flashcard.php?level=1" class="hsk-level-card level-1">
                        <div class="level-number">1</div>
                        <div class="level-info">
                            <h3>HSK 1</h3>
                            <p>Học từ vựng cấp độ cơ bản</p>
                        </div>
                    </a>
                    <a href="flashcard.php?level=2" class="hsk-level-card level-2">
                        <div class="level-number">2</div>
                        <div class="level-info">
                            <h3>HSK 2</h3>
                            <p>Học từ vựng cấp độ sơ cấp</p>
                        </div>
                    </a>
                    <a href="flashcard.php?level=3" class="hsk-level-card level-3">
                        <div class="level-number">3</div>
                        <div class="level-info">
                            <h3>HSK 3</h3>
                            <p>Học từ vựng cấp độ trung cấp</p>
                        </div>
                    </a>
                    <a href="flashcard.php?level=4" class="hsk-level-card level-4">
                        <div class="level-number">4</div>
                        <div class="level-info">
                            <h3>HSK 4</h3>
                            <p>Học từ vựng cấp độ cao cấp</p>
                        </div>
                    </a>
                </div>
            </div>
            <?php else: ?>
            <div class="flashcard-controls">
                <div class="control-group">
                    <label>Số lượng thẻ:</label>
                    <select id="flashcard-count">
                        <option value="10">10 thẻ</option>
                        <option value="20" selected>20 thẻ</option>
                        <option value="50">50 thẻ</option>
                        <option value="100">100 thẻ</option>
                    </select>
                </div>
                <button id="start-flashcard" class="btn btn-primary">Bắt Đầu</button>
            </div>

            <div class="flashcard-container" id="flashcard-container" style="display: none;">
                <div class="progress-bar">
                    <div class="progress-fill" id="progress-fill"></div>
                </div>
                <div class="progress-text">
                    <span id="current-card">0</span> / <span id="total-cards">0</span>
                </div>
                
                <div class="flashcard" id="flashcard">
                    <div class="flashcard-inner">
                        <div class="flashcard-front" id="flashcard-front">
                            <div class="card-content">
                                <div class="chinese-char" id="chinese-char"></div>
                                <div class="pinyin-text" id="pinyin-text"></div>
                            </div>
                        </div>
                        <div class="flashcard-back" id="flashcard-back">
                            <div class="card-content">
                                <div class="chinese-char" id="chinese-char-back"></div>
                                <div class="pinyin-text" id="pinyin-text-back"></div>
                                <div class="meaning-text" id="meaning-text"></div>
                                <div class="pos-text" id="pos-text"></div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="flashcard-actions">
                    <button class="btn btn-secondary" id="prev-card">← Trước</button>
                    <button class="btn btn-primary" id="flip-card">Lật Thẻ</button>
                    <button class="btn btn-success" id="know-card">Đã Biết ✓</button>
                    <button class="btn btn-danger" id="dont-know-card">Chưa Biết ✗</button>
                    <button class="btn btn-secondary" id="next-card">Sau →</button>
                </div>
                
                <div class="flashcard-stats">
                    <div class="stat-item">
                        <span class="stat-label">Đã biết:</span>
                        <span class="stat-value" id="known-count">0</span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-label">Chưa biết:</span>
                        <span class="stat-value" id="unknown-count">0</span>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
</main>

<script src="assets/js/flashcard.js"></script>
<script>
    window.flashcardLevel = <?php echo $level; ?>;
</script>

<?php require_once 'includes/footer.php'; ?>
