<?php
require_once 'config.php';
startSession();
requireLogin();

$pageTitle = 'Bài Tập';
require_once 'includes/header.php';

$level = isset($_GET['level']) ? intval($_GET['level']) : 0;
if ($level < 1 || $level > 4) $level = 0;
?>

<main>
    <section class="exercises-section">
        <div class="container">
            <h1 class="page-title">Bài Tập HSK</h1>
            
            <?php if ($level == 0): ?>
            <div class="level-selector">
                <h2>Chọn Cấp Độ HSK</h2>
                <div class="hsk-levels">
                    <a href="exercises.php?level=1" class="hsk-level-card level-1">
                        <div class="level-number">1</div>
                        <div class="level-info">
                            <h3>HSK 1</h3>
                            <p>Bài tập cấp độ cơ bản</p>
                        </div>
                    </a>
                    <a href="exercises.php?level=2" class="hsk-level-card level-2">
                        <div class="level-number">2</div>
                        <div class="level-info">
                            <h3>HSK 2</h3>
                            <p>Bài tập cấp độ sơ cấp</p>
                        </div>
                    </a>
                    <a href="exercises.php?level=3" class="hsk-level-card level-3">
                        <div class="level-number">3</div>
                        <div class="level-info">
                            <h3>HSK 3</h3>
                            <p>Bài tập cấp độ trung cấp</p>
                        </div>
                    </a>
                    <a href="exercises.php?level=4" class="hsk-level-card level-4">
                        <div class="level-number">4</div>
                        <div class="level-info">
                            <h3>HSK 4</h3>
                            <p>Bài tập cấp độ cao cấp</p>
                        </div>
                    </a>
                </div>
            </div>
            <?php else: ?>
            <div class="exercise-container">
                <div class="exercise-header">
                    <h2>Bài Tập HSK <?php echo $level; ?></h2>
                    <div class="exercise-types">
                        <button class="exercise-type-btn active" data-type="fill-blank">Điền Từ</button>
                        <button class="exercise-type-btn" data-type="multiple-choice">Chọn Đáp Án</button>
                        <button class="exercise-type-btn" data-type="translation">Dịch Câu</button>
                    </div>
                </div>
                
                <div class="exercise-content" id="exercise-content">
                    <div class="loading">
                        <div class="spinner"></div>
                        <p>Đang tải bài tập...</p>
                    </div>
                </div>
                
                <div class="exercise-actions">
                    <button id="check-answer" class="btn btn-primary" style="display: none;">Kiểm Tra</button>
                    <button id="next-exercise" class="btn btn-secondary" style="display: none;">Câu Tiếp Theo</button>
                    <button id="reset-exercise" class="btn btn-secondary">Làm Lại</button>
                </div>
                
                <div class="exercise-stats">
                    <div class="stat-item">
                        <span class="stat-label">Đúng:</span>
                        <span class="stat-value" id="correct-count">0</span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-label">Sai:</span>
                        <span class="stat-value" id="wrong-count">0</span>
                    </div>
                    <div class="stat-item">
                        <span class="stat-label">Tổng:</span>
                        <span class="stat-value" id="total-count">0</span>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
</main>

<script src="assets/js/exercises.js"></script>
<script>
    window.exerciseLevel = <?php echo $level; ?>;
</script>

<?php require_once 'includes/footer.php'; ?>

