// API Helper - Handle authentication and errors
async function apiRequest(url) {
    try {
        const response = await fetch(url);
        const data = await response.json();
        
        // Check if authentication is required
        if (data.auth_required || (data.error && data.error === 'Authentication required')) {
            window.location.href = 'login.php';
            return null;
        }
        
        if (data.error) {
            throw new Error(data.error);
        }
        
        return data;
    } catch (error) {
        console.error('API Error:', error);
        throw error;
    }
}

async function apiPost(url, data) {
    try {
        const response = await fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        // Check if authentication is required
        if (result.auth_required || (result.error && result.error === 'Authentication required')) {
            window.location.href = 'login.php';
            return null;
        }
        
        if (result.error) {
            throw new Error(result.error);
        }
        
        return result;
    } catch (error) {
        console.error('API Error:', error);
        throw error;
    }
}

