<?php
require_once '../config.php';
requireAdmin();

$conn = getDB();
$user_id = intval($_GET['id'] ?? 0);

if (!$user_id) {
    header('Location: users.php');
    exit;
}

$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = fetchStmtAssoc($stmt);
$stmt->close();

if (!$user) {
    header('Location: users.php');
    exit;
}

// Get user statistics
$stats = [
    'quiz_count' => 0,
    'total_progress' => 0,
    'known_words' => 0,
    'learning_words' => 0
];

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM quiz_results WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = fetchStmtAssoc($stmt);
$stats['quiz_count'] = $result['total'] ?? 0;
$stmt->close();

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM user_progress WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = fetchStmtAssoc($stmt);
$stats['total_progress'] = $result['total'] ?? 0;
$stmt->close();

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM user_progress WHERE user_id = ? AND known_status = 'known'");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = fetchStmtAssoc($stmt);
$stats['known_words'] = $result['total'] ?? 0;
$stmt->close();

$stmt = $conn->prepare("SELECT COUNT(*) as total FROM user_progress WHERE user_id = ? AND known_status = 'learning'");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = fetchStmtAssoc($stmt);
$stats['learning_words'] = $result['total'] ?? 0;
$stmt->close();

// Get recent quiz results
$stmt = $conn->prepare("SELECT * FROM quiz_results WHERE user_id = ? ORDER BY completed_at DESC LIMIT 10");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$recent_quizzes = fetchAllAssoc($stmt);
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chi Tiết User - Admin</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <nav class="navbar admin-navbar">
        <div class="container">
            <div class="nav-brand">
                <h1>中文学习</h1>
                <span>Admin Dashboard</span>
            </div>
            <ul class="nav-menu">
                <li><a href="../index.php">Trang Chủ</a></li>
                <li><a href="index.php">Dashboard</a></li>
                <li><a href="users.php" class="active">Quản Lý Users</a></li>
                <li><a href="../logout.php">Đăng Xuất</a></li>
            </ul>
        </div>
    </nav>

    <main class="admin-main">
        <div class="container">
            <div class="admin-header">
                <h1>Chi Tiết User</h1>
                <p><a href="users.php">← Quay lại danh sách users</a></p>
            </div>

            <div class="admin-section">
                <h2>Thông Tin User</h2>
                <div class="user-info-grid">
                    <div class="info-item">
                        <label>ID:</label>
                        <span><?php echo $user['id']; ?></span>
                    </div>
                    <div class="info-item">
                        <label>Username:</label>
                        <span><?php echo htmlspecialchars($user['username']); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Email:</label>
                        <span><?php echo htmlspecialchars($user['email']); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Họ Tên:</label>
                        <span><?php echo htmlspecialchars($user['full_name'] ?? '-'); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Vai Trò:</label>
                        <span>
                            <?php if ($user['is_admin']): ?>
                                <span class="badge badge-admin">Admin</span>
                            <?php else: ?>
                                <span class="badge badge-user">User</span>
                            <?php endif; ?>
                        </span>
                    </div>
                    <div class="info-item">
                        <label>Trạng Thái:</label>
                        <span>
                            <?php
                            $statusClass = 'badge-active';
                            $statusText = 'Hoạt Động';
                            if ($user['status'] === 'banned') {
                                $statusClass = 'badge-banned';
                                $statusText = 'Bị Khóa';
                            } elseif ($user['status'] === 'inactive') {
                                $statusClass = 'badge-inactive';
                                $statusText = 'Vô Hiệu';
                            }
                            ?>
                            <span class="badge <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </span>
                    </div>
                    <div class="info-item">
                        <label>Ngày Tạo:</label>
                        <span><?php echo date('d/m/Y H:i:s', strtotime($user['created_at'])); ?></span>
                    </div>
                    <div class="info-item">
                        <label>Đăng Nhập Cuối:</label>
                        <span><?php echo $user['last_login'] ? date('d/m/Y H:i:s', strtotime($user['last_login'])) : 'Chưa đăng nhập'; ?></span>
                    </div>
                </div>
            </div>

            <div class="stats-grid">
                <div class="stat-card stat-info">
                    <div class="stat-icon">📝</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['quiz_count']); ?></div>
                        <div class="stat-label">Bài Kiểm Tra</div>
                    </div>
                </div>
                
                <div class="stat-card stat-primary">
                    <div class="stat-icon">📊</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['total_progress']); ?></div>
                        <div class="stat-label">Tổng Tiến Độ</div>
                    </div>
                </div>
                
                <div class="stat-card stat-success">
                    <div class="stat-icon">✓</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['known_words']); ?></div>
                        <div class="stat-label">Từ Đã Biết</div>
                    </div>
                </div>
                
                <div class="stat-card stat-warning">
                    <div class="stat-icon">📖</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['learning_words']); ?></div>
                        <div class="stat-label">Đang Học</div>
                    </div>
                </div>
            </div>

            <div class="admin-section">
                <h2>Kết Quả Kiểm Tra Gần Đây</h2>
                <?php if (empty($recent_quizzes)): ?>
                    <p>Chưa có kết quả kiểm tra nào</p>
                <?php else: ?>
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>HSK Level</th>
                                    <th>Loại</th>
                                    <th>Số Câu</th>
                                    <th>Đúng</th>
                                    <th>Điểm</th>
                                    <th>Ngày Hoàn Thành</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_quizzes as $quiz): ?>
                                    <tr>
                                        <td><?php echo $quiz['id']; ?></td>
                                        <td><?php echo htmlspecialchars($quiz['hsk_level'] ?? '-'); ?></td>
                                        <td><?php echo htmlspecialchars($quiz['quiz_type'] ?? '-'); ?></td>
                                        <td><?php echo $quiz['total_questions']; ?></td>
                                        <td><?php echo $quiz['correct_answers']; ?></td>
                                        <td><?php echo $quiz['score']; ?>%</td>
                                        <td><?php echo date('d/m/Y H:i', strtotime($quiz['completed_at'])); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <p>&copy; 2024 Học Tiếng Trung HSK. Tất cả quyền được bảo lưu.</p>
        </div>
    </footer>

    <style>
        .user-info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
        }
        
        .info-item {
            padding: 1rem;
            background: #f5f5f5;
            border-radius: 8px;
        }
        
        .info-item label {
            display: block;
            font-weight: 600;
            color: var(--text-secondary);
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }
        
        .info-item span {
            display: block;
            color: var(--text-primary);
            font-size: 1.1rem;
        }
    </style>
</body>
</html>

