<?php
require_once '../config.php';
requireAdmin();

$conn = getDB();
$currentUser = getCurrentUser();

// Get statistics
$stats = [
    'total_users' => 0,
    'active_users' => 0,
    'banned_users' => 0,
    'total_quizzes' => 0,
    'total_progress' => 0
];

$result = $conn->query("SELECT COUNT(*) as total FROM users");
$stats['total_users'] = $result->fetch_assoc()['total'];

$result = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 'active'");
$stats['active_users'] = $result->fetch_assoc()['total'];

$result = $conn->query("SELECT COUNT(*) as total FROM users WHERE status = 'banned'");
$stats['banned_users'] = $result->fetch_assoc()['total'];

$result = $conn->query("SELECT COUNT(*) as total FROM quiz_results");
$stats['total_quizzes'] = $result->fetch_assoc()['total'];

$result = $conn->query("SELECT COUNT(*) as total FROM user_progress");
$stats['total_progress'] = $result->fetch_assoc()['total'];

// Get recent users
$result = $conn->query("SELECT id, username, email, full_name, is_admin, status, created_at, last_login 
                        FROM users ORDER BY created_at DESC LIMIT 10");
$recentUsers = $result ? fetchAllAssoc($result) : [];
?>
<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Học Tiếng Trung HSK</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@300;400;500;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <nav class="navbar admin-navbar">
        <div class="container">
            <div class="nav-brand">
                <h1>中文学习</h1>
                <span>Admin Dashboard</span>
            </div>
            <ul class="nav-menu">
                <li><a href="../index.php">Trang Chủ</a></li>
                <li><a href="index.php" class="active">Dashboard</a></li>
                <li><a href="users.php">Quản Lý Users</a></li>
                <li><a href="../logout.php">Đăng Xuất</a></li>
            </ul>
        </div>
    </nav>

    <main class="admin-main">
        <div class="container">
            <div class="admin-header">
                <h1>Dashboard</h1>
                <p>Xin chào, <?php echo htmlspecialchars($currentUser['full_name'] ?? $currentUser['username']); ?>!</p>
            </div>

            <div class="stats-grid">
                <div class="stat-card stat-primary">
                    <div class="stat-icon">👥</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['total_users']); ?></div>
                        <div class="stat-label">Tổng Users</div>
                    </div>
                </div>
                
                <div class="stat-card stat-success">
                    <div class="stat-icon">✓</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['active_users']); ?></div>
                        <div class="stat-label">Users Hoạt Động</div>
                    </div>
                </div>
                
                <div class="stat-card stat-danger">
                    <div class="stat-icon">🚫</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['banned_users']); ?></div>
                        <div class="stat-label">Users Bị Khóa</div>
                    </div>
                </div>
                
                <div class="stat-card stat-info">
                    <div class="stat-icon">📝</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['total_quizzes']); ?></div>
                        <div class="stat-label">Bài Kiểm Tra</div>
                    </div>
                </div>
                
                <div class="stat-card stat-warning">
                    <div class="stat-icon">📊</div>
                    <div class="stat-content">
                        <div class="stat-number"><?php echo number_format($stats['total_progress']); ?></div>
                        <div class="stat-label">Tiến Độ Học Tập</div>
                    </div>
                </div>
            </div>

            <div class="admin-section">
                <h2>Users Gần Đây</h2>
                <div class="table-container">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Email</th>
                                <th>Họ Tên</th>
                                <th>Vai Trò</th>
                                <th>Trạng Thái</th>
                                <th>Ngày Tạo</th>
                                <th>Hành Động</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($recentUsers)): ?>
                                <tr>
                                    <td colspan="8" class="text-center">Không có dữ liệu</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($recentUsers as $user): ?>
                                    <tr>
                                        <td><?php echo $user['id']; ?></td>
                                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                                        <td><?php echo htmlspecialchars($user['full_name'] ?? '-'); ?></td>
                                        <td>
                                            <?php if ($user['is_admin']): ?>
                                                <span class="badge badge-admin">Admin</span>
                                            <?php else: ?>
                                                <span class="badge badge-user">User</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php
                                            $statusClass = 'badge-active';
                                            $statusText = 'Hoạt Động';
                                            if ($user['status'] === 'banned') {
                                                $statusClass = 'badge-banned';
                                                $statusText = 'Bị Khóa';
                                            } elseif ($user['status'] === 'inactive') {
                                                $statusClass = 'badge-inactive';
                                                $statusText = 'Vô Hiệu';
                                            }
                                            ?>
                                            <span class="badge <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                                        </td>
                                        <td><?php echo date('d/m/Y', strtotime($user['created_at'])); ?></td>
                                        <td>
                                            <a href="user_detail.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-primary">Chi Tiết</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>

    <footer class="footer">
        <div class="container">
            <p>&copy; 2024 Học Tiếng Trung HSK. Tất cả quyền được bảo lưu.</p>
        </div>
    </footer>
</body>
</html>

