# Hướng Dẫn Cài Đặt Database

## Cách 1: Tự Động (Khuyến Nghị)

Website sẽ tự động tạo database và các bảng khi bạn truy cập lần đầu tiên.

1. Đảm bảo MySQL/MariaDB đang chạy
2. Cập nhật thông tin database trong file `config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_USER', 'root');
   define('DB_PASS', '');  // Mật khẩu MySQL của bạn
   define('DB_NAME', 'hsk_learning');
   ```
3. Truy cập website: `http://localhost/hsk-learning`
4. Database sẽ được tạo tự động
5. Truy cập `http://localhost/hsk-learning/install.php` để kiểm tra cài đặt

## Cách 2: Thủ Công (Nếu tự động không hoạt động)

### Bước 1: Tạo Database

1. Mở phpMyAdmin hoặc MySQL command line
2. Tạo database mới:
   ```sql
   CREATE DATABASE hsk_learning CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
   ```

### Bước 2: Import SQL File

**Option A: Sử dụng phpMyAdmin**
1. Chọn database `hsk_learning`
2. Click tab "Import"
3. Chọn file `database.sql`
4. Click "Go"

**Option B: Sử dụng MySQL Command Line**
```bash
mysql -u root -p hsk_learning < database.sql
```

### Bước 3: Tạo Admin User

Admin user sẽ được tạo tự động khi bạn truy cập website lần đầu. Nếu không, bạn có thể tạo thủ công:

```sql
USE hsk_learning;

INSERT INTO users (username, email, password, full_name, is_admin) 
VALUES ('admin', 'admin@hsklearning.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrator', 1);
```

**Lưu ý:** Password hash trên là của mật khẩu `admin123`. Nên đổi mật khẩu sau khi đăng nhập.

## Kiểm Tra Cài Đặt

Truy cập: `http://localhost/hsk-learning/install.php`

Trang này sẽ hiển thị:
- ✓ Kết nối database thành công
- ✓ Các bảng đã được tạo
- ✓ Admin user đã tồn tại

## Xử Lý Lỗi

### Lỗi: "Access denied for user"
- Kiểm tra username và password trong `config.php`
- Đảm bảo MySQL user có quyền CREATE DATABASE và CREATE TABLE

### Lỗi: "Table already exists"
- Không sao, bảng đã tồn tại rồi
- Website sẽ tiếp tục hoạt động bình thường

### Lỗi: "Foreign key constraint fails"
- Đảm bảo bảng `users` được tạo trước các bảng khác
- Xóa tất cả bảng và tạo lại từ đầu

### Lỗi: "Unknown database"
- Tạo database thủ công trước:
  ```sql
  CREATE DATABASE hsk_learning CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
  ```

## Thông Tin Đăng Nhập Mặc Định

- **Username:** admin
- **Password:** admin123
- **⚠️ QUAN TRỌNG:** Đổi mật khẩu ngay sau khi đăng nhập lần đầu!

## Cấu Trúc Database

### Bảng `users`
- Lưu thông tin người dùng
- Bao gồm: id, username, email, password, full_name, is_admin, status, created_at, last_login

### Bảng `user_progress`
- Lưu tiến độ học từ vựng của user
- Bao gồm: id, user_id, word_simplified, hsk_level, known_status, times_reviewed, last_reviewed

### Bảng `quiz_results`
- Lưu kết quả bài kiểm tra
- Bao gồm: id, user_id, hsk_level, total_questions, correct_answers, score, quiz_type, completed_at

## Hỗ Trợ

Nếu gặp vấn đề, vui lòng:
1. Kiểm tra file `install.php` để xem lỗi chi tiết
2. Kiểm tra log lỗi của PHP và MySQL
3. Đảm bảo MySQL/MariaDB đang chạy
4. Kiểm tra quyền của MySQL user

