# Website Học Tiếng Trung HSK

Website học từ vựng tiếng Trung HSK từ cấp độ 1 đến 4, được xây dựng từ các file JSON chứa từ vựng HSK theo từng cấp độ.

## Tính Năng

### 1. Trang Chủ
- Hiển thị thống kê tổng số từ vựng
- Thống kê số lượng từ vựng theo từng cấp độ HSK (1-4)
- Hiển thị từ vựng ngẫu nhiên

### 2. Từ Vựng
- Tìm kiếm từ vựng theo chữ Hán, pinyin hoặc nghĩa tiếng Việt
- Lọc theo cấp độ HSK (1-4)
- Hiển thị đầy đủ thông tin: chữ Hán giản thể, pinyin, nghĩa tiếng Việt
- Phân trang để dễ dàng duyệt qua nhiều từ vựng

### 3. Flashcard
- Học từ vựng bằng flashcard
- Chọn cấp độ HSK và số lượng thẻ
- Lật thẻ để xem nghĩa
- Đánh dấu từ đã biết/chưa biết
- Theo dõi tiến độ học tập
- Hỗ trợ phím tắt:
  - `←` / `→`: Chuyển thẻ trước/sau
  - `Space` / `Enter`: Lật thẻ
  - `1`: Đánh dấu đã biết
  - `2`: Đánh dấu chưa biết

### 4. Kiểm Tra (Quiz)
- Làm bài kiểm tra từ vựng
- Chọn cấp độ HSK và số lượng câu hỏi
- Các loại câu hỏi:
  - Chọn nghĩa đúng
  - Chọn pinyin đúng
  - Hỗn hợp
- Hiển thị kết quả và điểm số sau khi hoàn thành

## Yêu Cầu Hệ Thống

- PHP 7.0 trở lên
- MySQL/MariaDB
- Web server (Apache, Nginx, hoặc PHP built-in server)
- Các file JSON HSK trong thư mục `hsk/`:
  - `hsk1.json` - Từ vựng HSK 1
  - `hsk2.json` - Từ vựng HSK 2
  - `hsk3.json` - Từ vựng HSK 3
  - `hsk4.json` - Từ vựng HSK 4

## Cài Đặt

1. **Cấu hình Database:**
   - Mở file `config.php` và cập nhật thông tin kết nối database:
     ```php
     define('DB_HOST', 'localhost');
     define('DB_USER', 'root');
     define('DB_PASS', '');
     define('DB_NAME', 'hsk_learning');
     ```
   - Database sẽ tự động được tạo khi truy cập website lần đầu
   - Hoặc import file `database.sql` vào MySQL

2. **Đảm bảo các file JSON HSK nằm trong thư mục `hsk/` bên trong thư mục `hsk-learning/`**

3. **Cấu trúc thư mục:**
```
abczz/
└── hsk-learning/
    ├── api.php
    ├── config.php
    ├── index.php
    ├── vocabulary.php
    ├── flashcard.php
    ├── exercises.php
    ├── login.php
    ├── register.php
    ├── logout.php
    ├── profile.php
    ├── database.sql
    ├── hsk/
    │   ├── hsk1.json
    │   ├── hsk2.json
    │   ├── hsk3.json
    │   └── hsk4.json
    ├── admin/
    │   ├── index.php
    │   ├── users.php
    │   └── user_detail.php
    ├── assets/
    │   ├── css/
    │   │   ├── style.css
    │   │   ├── auth.css
    │   │   └── admin.css
    │   └── js/
    │       ├── main.js
    │       ├── vocabulary.js
    │       ├── flashcard.js
    │       └── exercises.js
    └── README.md
```

4. **Khởi động web server:**
   - Nếu dùng XAMPP: Copy thư mục `hsk-learning` vào `htdocs` và truy cập `http://localhost/hsk-learning`
   - Nếu dùng PHP built-in server:
     ```bash
     cd hsk-learning
     php -S localhost:8000
     ```
     Sau đó truy cập `http://localhost:8000`

5. **Tài khoản Admin mặc định:**
   - Username: `admin`
   - Password: `admin123`
   - **Lưu ý:** Đổi mật khẩu ngay sau khi đăng nhập lần đầu!

## Sử Dụng

### Cho Người Dùng

1. **Đăng Ký/Đăng Nhập:**
   - Truy cập trang đăng ký để tạo tài khoản mới
   - Đăng nhập để lưu tiến độ học tập
   - Không cần đăng nhập để sử dụng các tính năng cơ bản

2. **Học Tập:**
   - Truy cập trang chủ để xem thống kê
   - Vào "Từ Vựng" để tìm kiếm và duyệt từ vựng
   - Vào "Flashcard" để học từ vựng bằng thẻ
   - Vào "Kiểm Tra" để làm bài test
   - Xem "Hồ Sơ" để theo dõi tiến độ học tập

3. **Tính Năng:**
   - Tìm kiếm từ vựng theo chữ Hán, pinyin hoặc nghĩa tiếng Việt
   - Lọc theo cấp độ HSK (1-4)
   - Học bằng flashcard với hiệu ứng 3D
   - Làm bài tập đa dạng: điền từ, trắc nghiệm, dịch
   - Theo dõi tiến độ học tập (nếu đã đăng nhập)

### Cho Admin

1. **Đăng nhập với tài khoản admin**

2. **Quản Lý Users:**
   - Xem danh sách tất cả users
   - Tìm kiếm và lọc users
   - Xem chi tiết user
   - Khóa/Mở khóa user
   - Thêm/Gỡ quyền admin
   - Xóa user

3. **Thống Kê:**
   - Xem tổng số users
   - Xem số users hoạt động/bị khóa
   - Xem số bài kiểm tra đã làm
   - Xem tổng tiến độ học tập

## Giao Diện

- **Thiết kế hiện đại, responsive:** Giao diện đẹp mắt với gradient và hiệu ứng mượt mà
- **Hỗ trợ font chữ Trung Quốc:** Sử dụng Noto Sans SC cho chữ Hán
- **Màu sắc đẹp mắt:** Gradient màu sắc hiện đại, dễ nhìn
- **Tối ưu cho cả desktop và mobile:** Responsive design hoàn chỉnh
- **Hiệu ứng tương tác:** Hover effects, animations, transitions mượt mà
- **User Menu:** Dropdown menu với thông tin user và các tùy chọn
- **Admin Panel:** Giao diện quản trị chuyên nghiệp với bảng dữ liệu đẹp mắt

## API Endpoints

### `api.php?action=get_stats`
Lấy thống kê tổng số từ vựng và số lượng theo từng cấp độ.

### `api.php?action=get_all`
Lấy danh sách từ vựng với các tham số:
- `level`: Cấp độ HSK (1 đến 4, hoặc 'all')
- `search`: Từ khóa tìm kiếm (chữ Hán, pinyin, hoặc nghĩa tiếng Việt)
- `page`: Số trang
- `limit`: Số lượng từ vựng mỗi trang

### `api.php?action=get_random`
Lấy từ vựng ngẫu nhiên với các tham số:
- `level`: Cấp độ HSK (1 đến 4, hoặc 'all')
- `count`: Số lượng từ vựng

### `api.php?action=save_quiz_result` (POST)
Lưu kết quả kiểm tra (yêu cầu đăng nhập):
- `hsk_level`: Cấp độ HSK
- `total_questions`: Tổng số câu hỏi
- `correct_answers`: Số câu đúng
- `score`: Điểm số (%)
- `quiz_type`: Loại bài kiểm tra

## Tính Năng Mới

### Hệ Thống Đăng Nhập/Đăng Ký
- Đăng ký tài khoản mới
- Đăng nhập với username/email
- Ghi nhớ đăng nhập
- Quản lý session
- Bảo mật mật khẩu với password hashing

### Quản Lý User
- Xem hồ sơ cá nhân
- Theo dõi tiến độ học tập
- Xem lịch sử bài kiểm tra
- Thống kê từ vựng đã học

### Admin Panel
- Dashboard với thống kê tổng quan
- Quản lý users (xem, tìm kiếm, lọc)
- Khóa/Mở khóa users
- Thêm/Gỡ quyền admin
- Xóa users
- Xem chi tiết user và tiến độ học tập

### Cải Thiện UI/UX
- Giao diện đẹp hơn với gradient và hiệu ứng
- User menu dropdown
- Animations và transitions mượt mà
- Responsive design hoàn chỉnh
- Loading states và error handling

## Ghi Chú

- Dữ liệu từ vựng được tải từ các file JSON riêng biệt cho từng cấp độ HSK (1-4)
- Tất cả nghĩa đã được dịch sang tiếng Việt
- Database sẽ tự động được tạo khi truy cập website lần đầu
- Đổi mật khẩu admin ngay sau khi đăng nhập lần đầu
- Website vẫn hoạt động mà không cần đăng nhập, nhưng đăng nhập để lưu tiến độ học tập
- File JSON được cache trong bộ nhớ để tối ưu hiệu suất

## Tác Giả

Website được tạo để hỗ trợ học tiếng Trung HSK một cách hiệu quả và thú vị.

